/*
* @author 	jingleyang
* @date		2010-02-15
*/
var downloadbar = {
	// 下载dll 
	extID : "{7EDBEBE6-565F-4aa2-93A1-AD250445A5B6}",
	WindowID:0,	
	// datastruct 数据结构
	Status:{
		initnew:"new",
		download:"download",
		pause:"pause",
		complete:"complete",
		fail:"fail",
		//以下为downloadTaskInfo专用
		handled:"handled",
		unhandled:"unhandled"
	},
	// initDLL
	dllobj: null,
	// 全局的下载信息数组
	tasklist : [],
	downloadTaskInfo : {},
	
	init:function()
	{
		downloadbar.initDLL();
		downloadbar.initBar();
		downloadbar.regListener();
		// 测试
		//downloadbar.test_init(2);
		//downloadbar.test_init(3);
		//记录任务完成情况
	},
	
	recoverFromFlashItem : function ( taskid ){
		aim=$("#download-items .download-item[taskid="+taskid+"]");
		console.info(aim);
		aim.css("border","1px solid hsl(215, 80%, 40%)");
		aim.css("margin-left","2px");
		aim.css("margin-right","2px");
		aim.css("margin-top","0px");		
		aim.css("height","38px");	
		downloadbar.handledCompleteTask(taskid);
	},
		
	sendMsgToDownload: function (cmdName,taskid){
		try{
			console.info("cmd: "+cmdName+" id: "+taskid);
			
			var cmd={
				command:cmdName,
				id:taskid
			};
			if( 'openfile' == cmdName || 'openfolder' == cmdName )
			{
				downloadbar.recoverFromFlashItem(taskid);
			}

			qqbrowser.extension.sendRequest(downloadbar.extID, cmd,
				function(reply){
					console.info("replay: "+reply);
				}
			);
			}catch(err){
				//alert("cmd: "+cmdName+" id: "+taskid);
			}
	},

	getPosition:function ( object ) { /*獲取元素的絕對位置*/
		var left = 0;
		var top = 0;
		if (object.getBoundingClientRect) {
		    var pos = object.getBoundingClientRect();
		    left = pos.left + document.documentElement.scrollLeft;
		    top = pos.top + document.documentElement.scrollTop;
		    return { Left: left, Top: top };
		}
		else {
		    while (object.offsetParent) {
		        left += object.offsetLeft;
		        top += object.offsetTop;
		        object = object.offsetParent;
		    }
		    return { Left: left, Top: top };
		}
	},
			
	popupMenu: function ( object , cmdName ,taskid){
		console.info("cmd: "+cmdName+" id: "+taskid);
		
		var cmd={
			command:cmdName,
			id:taskid
		};
		
		downloadbar.recoverFromFlashItem(taskid);
		
		try{
			var pos = downloadbar.getPosition(object);
			cmd.topleftx = pos.Left;
			cmd.toplefty = pos.Top;
			cmd.bottomrightx = pos.Left + 10;
			cmd.bottomrighty = pos.Top + 36;
			cmd.mainwndid = WindowID;

			qqbrowser.extension.sendRequest(downloadbar.extID, cmd,
				function(reply){
					console.info("replay: "+reply);
				} );
		}catch(err){
			//alert("cmd: "+cmdName+" id: "+taskid);
		}
	},
	
	handledCompleteTask : function (taskID )
	{
		downloadbar.downloadTaskInfo[taskID] = downloadbar.Status.handled;
		downloadbar.updateStatusBarIcon();
	},
	
	updataStatusbarIcon :function (para)
	{		
		var ind = downloadbar.getItemIndex(para);
		if (-1==ind){
			return;
		}
		if( downloadbar.Status.download == para.status )
		{
			downloadbar.downloadTaskInfo[para.id] = downloadbar.Status.download;
		}
		else if( downloadbar.Status.pause == para.status )
		{
			downloadbar.downloadTaskInfo[para.id] = downloadbar.Status.pause;
		}
		else if( downloadbar.Status.fail == para.status )
		{
			downloadbar.downloadTaskInfo[para.id] = downloadbar.Status.fail;
		}		
		else if( downloadbar.Status.complete == para.status )
		{
			if ( ($("#download-display").attr("class").indexOf("-pressed")) == -1){
				downloadbar.downloadTaskInfo[para.id] = downloadbar.Status.unhandled;
			}
			else{
				delete downloadbar.downloadTaskInfo[para.id];
			}
		}

		if ("delete" ==para.msgtype)
		{
			delete downloadbar.downloadTaskInfo[para.id];
		}
		
		downloadbar.updateStatusBarIcon();		
	},
	
	updateStatusBarIcon:function ()
	{
		var downloadingFlag = 0;
		var handledFlag = 0;
		for( var i in downloadbar.downloadTaskInfo){ if(downloadbar.Status.download== downloadbar.downloadTaskInfo[i]){ downloadingFlag = 1 ;break;}};
		//for( var i in downloadbar.downloadTaskInfo){ if(downloadbar.Status.unhandled== downloadbar.downloadTaskInfo[i]){ handledFlag = 1 ;break;}};
		for( var i in downloadbar.downloadTaskInfo){ if(downloadbar.Status.unhandled== downloadbar.downloadTaskInfo[i]){ handledFlag++;}};
		if( 1 == downloadingFlag)
		{
			$("#download-display-img").css("background","url(../aero/images/statusbar/downloading.gif)  4px 4px no-repeat");
		}
		else
		{
			$("#download-display-img").css("background","url(../aero/images/statusbar/download_logo.png)  4px 4px no-repeat");
		}
		
		if(handledFlag){
			$("#download-display-img-float").css("visibility","visible");
			//view.drawNumber($("#download-num")[0], handledFlag);
		}
		else
		{
			$("#download-display-img-float").css("visibility","hidden");		
		}
	},
	
	removeStatusBarIconData:function()
	{
		for( var i in downloadbar.downloadTaskInfo){
			if(downloadbar.Status.unhandled== downloadbar.downloadTaskInfo[i]){
				delete downloadbar.downloadTaskInfo[i];
			}
		}
		downloadbar.updateStatusBarIcon();
	},
	
	initDLL:function (){
		try{
			downloadbar.dllobj=qqbrowser.extension.dllLoader("navigator_download_handler.dll");
			//只做一次
			downloadbar.dllobj.execDllFunc("OnLoadDll");
		}catch(err){
			console.info("load dll error");
		}
	},
	initBar:function (){
		WindowID = qqbrowser.window.currentId();
		// hide bar
		//downloadbar.hidebar();
		layout.resize();
	},
	hidebar:function (){
		//$("#downloadbar").hide();
		//layout.resize();
        if ( ($("#download-display").attr("class").indexOf("-pressed")) != -1) {
    		$("#download-display").mousedown();		
        }	
	},
	showbar:function (){
		//$("#downloadbar").show();
		//layout.resize();		
        if ( ($("#download-display").attr("class").indexOf("-pressed")) == -1) {
		    $("#download-display").mousedown();
        }
	},
	regListener:function (){
		try{
			qqbrowser.extension.onEvent.addListener(downloadbar.downHandler,{evtOwner:downloadbar.extID});
			//alert("not reg download listener");
		}catch(err){
			console.info("add listener error");
		}
		// 跳转下载管理
		$("#downloadbar-showall").click(function(){
			try{
				qqbrowser.tabs.create( "qqbrowser:download", 0 , qqbrowser.window.currentId() , 0 );
			}
			catch(err){
			}
		});
		$("#downloadbar-close").click(function(){
			downloadbar.hidebar();
            // 移除 "-pressed" 属性，是下载栏按钮显示为 normal 状态。
            // 既然按第二次下载按钮也可以关闭 download bar，那么后续是否可以
            // 考虑不要 download bar 右边的 ×？
            //var className = $("#download-display").attr("class");
            //$("#download-display").attr("class", className.substr(0, className.indexOf("-pressed")));
		});
	},
	downHandler:function (evtName, evtParam){
				var para = downloadbar.getPara( evtName, evtParam);
				if (null==para){
					//alert("parser para failed : "+evtParam);
					return ;
				}
				//如果是弹出tips直接弹出然后返回
				if( "eventcontinuedownload" == para.msgtype ){
					var param = {
						title:"",
						content:"正在下载上次未完成的任务...",
						padding:"6px"
					};
					var position = downloadbar.getPosition($("#download-display")[0]);
					var popRect = {
					'topLeftX': position.Left, 
					'topLeftY': position.Top , 
					'bottomRightX': position.Left + 24 ,
					'bottomRightY': position.Top + 24};
					var tooltipId = qqbrowser.tooltip.create( WindowID , popRect, {}, param, function() {
							//alert("call back");
					});
					setTimeout("browser.tooltip.destroy(" + tooltipId + ")", 10000);
					return;
				}
				// update item
				downloadbar.updataStatusbarIcon(para);
				downloadbar.updateItem(para);
	},
	
	getPara:function ( evtName, evtParam){
		var ret=null;
		try{
			ret=eval("("+evtParam+")");
			if( WindowID != ret.windowid )
			{					
				return null;
			}
		}catch(err){
			//alert("eval failed");
		}
		return ret;
	},
	
	flashItem:function (para){
		aim=$("#download-items .download-item[taskid="+para.id+"]");
		console.info(aim);
		aim.css("border","2px solid hsl(45, 75%, 40%)");
		aim.css("margin-top","-1px");
		aim.css("margin-left","1px");
		aim.css("margin-right","1px");
		var proc = aim.children(".download-process");
		proc.css("background","-webkit-gradient(linear, left top, left bottom, from(hsla(210, 70%, 95%, 0)), to(hsla(210, 70%, 75%, 0)))");
		aim.css("background","-webkit-gradient(linear, 0% 0%,0% 100%, from(hsla(210,15%,100%,1)),to(hsla(210,15%,100%,0)))");
		var val = 0.4 ;
		var speed = '100';
		// 三次闪烁
		aim.
			animate({opacity:'-='+val},speed).
			animate({opacity:'+='+val},speed).
			animate({opacity:'-='+val},speed).
			animate({opacity:'+='+val},speed).
			animate({opacity:'-='+val},speed,function(){
			}).
			animate({opacity:'+='+val},speed,function(){
				aim.css("-webkit-box-shadow","hsla(45, 100%, 30%, 0.5) 0px 0px 5px");
			});
	},
	
	updateItem:function (para){
		if (downloadbar.Status.initnew==para.msgtype){
			// 新的下载项
			if( "1" == para.showbar )
			{
				downloadbar.showbar();	
			}
			downloadbar.addItem(para);
		}else if("update"==para.msgtype){
			//如果不存在这个任务在这里添加任务的button
			var ind = downloadbar.getItemIndex(para);
			if ( -1 == ind ){
				downloadbar.addItem(para);
				if( "1" == para.showbar )
				{
					downloadbar.showbar();	
				}	
			}
			// 更新下载项
			var chstat = downloadbar.refreshItem(para);
			if (chstat){
				if (downloadbar.Status.complete == para.status){
					downloadbar.flashItem(para);
				}
			}
		}else if ("fail"==para.msgtype){
			// 更新下载项
			var chstat = downloadbar.refreshItem(para);
			if (chstat){
				if (downloadbar.Status.complete == para.status){
					downloadbar.flashItem(para);
				}
			}
		}else if ("delete" ==para.msgtype){
			downloadbar.deleteItem(para);
		}else if("seticon" ==para.msgtype ){
			downloadbar.setItemImage(para);			
		}else{
			//alert("update Item msgtype error");
		}
		// 这里可以判断有没有任务
		if (0==downloadbar.tasklist.length){
			$("#download-msg").show();
		}else{
			$("#download-msg").hide();
		}
	},
	deleteItem:function (para){
		var aim=$("#download-items .download-item[taskid="+para.id+"]");
		aim.remove();
		var ind = downloadbar.getItemIndex(para);
		if (-1==ind){
			return;
		}
		console.info("ind find: "+ind);
		console.info("tasklist before size: "+ downloadbar.tasklist.length);
		downloadbar.tasklist.splice(ind,1);
		console.info("tasklist after size: "+downloadbar.tasklist.length);
	},
	setItemImage:function (para){
		//debugger;
		var aim=$("#download-items .download-item[taskid="+para.id+"]");		
		$('.download-item-image-ico',aim).attr("src",para.iconfile);
	},	
	
	bindButtonClick:function( objHTML , Id)
	{
		var aim=$("#download-items .download-item[taskid="+Id+"]");
		aim[0].outerHTML=objHTML;
		// 添加响应Listener
		// 需要重新取一次
		aim=$("#download-items .download-item[taskid="+Id+"]");
		var proc = aim.children(".download-process");
		proc.width(proc.width()-2);
		aim.children(".download-item-inner").click(function(){
			var taskid = $(this.parentNode).attr('taskid');
		//	alert(taskid);
			var ind = downloadbar.getItemIndex({id:taskid});
			var stat = downloadbar.tasklist[ind].status;
			if (downloadbar.Status.initnew == stat||
			downloadbar.Status.download == stat){
				downloadbar.sendMsgToDownload('pause',taskid);
			//	downloadbar.updataStatusbarIcon(para);
			}else if (downloadbar.Status.pause == stat){
				if('onstart' != event.target.id){
					downloadbar.sendMsgToDownload('start',taskid);
				}
			//	downloadbar.updataStatusbarIcon(para);
			}else if (downloadbar.Status.failed == stat){
			//	downloadbar.updataStatusbarIcon(para);
			}
			else if(downloadbar.Status.complete == stat){
				if( 'openfile' != event.target.id &&
				 'openfolder' != event.target.id)
				{
					//downloadbar.sendMsgToDownload('openfile',taskid);
					downloadbar.recoverFromFlashItem(taskid);	
				}
				downloadbar.handledCompleteTask(taskid);	
			}
		});
		aim.children(".download-item-inner").hover(function(){
			var taskid = $(this).attr('taskid');
		},function(){
		});			
	},
	addItem:function (para){
		var obj = new downloadbar.TaskInfo(para.id, para.url, unescape(para.name), unescape(para.savepath), para.filetype );
		if( "undefine" != para.status ){
			obj.status = para.status;
		}
		if( "undefine" != para.totalsize ){
			obj.totalsize = para.totalsize;
		}
		if( "undefine" != para.currentsize ){
			obj.currentsize = para.currentsize;
		}
		
		console.info(obj);
		var objHTML = downloadbar.getHTML(obj);
		$("#download-items").prepend(objHTML);
		downloadbar.tasklist.push(obj);
		downloadbar.bindButtonClick( objHTML, para.id);
	},
	// 通过数据结构生成一个task item 的div
	getHTML:function (obj){
		var typeclass ="";
		console.info(obj.status);
		if (downloadbar.Status.initnew == obj.status){
			typeclass="new";	
		}else if (downloadbar.Status.complete==obj.status){
			typeclass="done";
		}
		else if (downloadbar.Status.fail==obj.status){
			typeclass="fail";
		}
		else if (downloadbar.Status.pause==obj.status){
			typeclass="pause";
		}
		var ret='<div class="download-item '+typeclass+' " taskid='+ obj.id+' > \r\n';
		ret+=downloadbar.getInner(obj)+"\r\n";
		ret+='<div class="download-item-menu" onclick="downloadbar.popupMenu(' +"this" + ',' +"'openmenu'" + ',' +obj.id + ');"></div> \r\n';
		ret+=downloadbar.getProcess(obj)+"\r\n";
		ret+="</div>\r\n";
		return ret;
	},
	// 根据数据拼出来 inner div
	getInner:function (obj){
		var basepath = "../aero/images/statusbar/";
		var imgpath =basepath;
		if (downloadbar.Status.initnew==obj.status||
		downloadbar.Status.download==obj.status){
			imgpath +="download_status_downloading.png";
		}else if (downloadbar.Status.pause == obj.status){
			imgpath += "download_status_paused.png";
		}else if (downloadbar.Status.fail == obj.status){
			imgpath += "download_status_error.png";
		}else if (downloadbar.Status.complete == obj.status){
			imgpath += "download_status_finished.png";
		}
	   	basepath+"icon_history_site.png";
		var ret='<div class="download-item-inner">';
		ret+='<div class="download-item-image">';
		ret+='<img class="download-item-image-ico" src="'+basepath + obj.filetype +'.ico' +'"></img>';	
		ret+='<div class="download-item-image-action" style="background:url('+ imgpath +') no-repeat"></div>';
		ret+='</div> \r\n';	
		ret+='<div class="download-item-display"> \r\n';		
		ret+='<div class="download-item-title">'+ obj.name+'</div> \r\n';
		ret+='<div class="download-item-action">\r\n';
		ret+=downloadbar.getInnerAct(obj);
		ret+='</div> \r\n';
		ret+=downloadbar.getInnerInfo(obj);
		ret+='</div>';
		ret+='</div>';	
		return ret;	
	},
	// 根据数据拼出  download-item-action
	getInnerAct:function (obj){
		ret="";
		if (downloadbar.Status.complete==obj.status){
			if( obj.openbtntext != "" && typeof(obj.openbtntext)!='undefined' ){
				ret+='<div id="openfile" class="download-item-openfile" onclick="downloadbar.sendMsgToDownload('+"'openfile'"+','+obj.id+');">' + unescape(obj.openbtntext) + '</div>\r\n';			
			}else{
				ret+='<div id="openfile" class="download-item-openfile" onclick="downloadbar.sendMsgToDownload('+"'openfile'"+','+obj.id+');">打开</div>\r\n';			
			}
			ret+='<div id="openfolder" class="download-item-openfolder" onclick="downloadbar.sendMsgToDownload('+"'openfolder'"+','+obj.id+');">打开文件夹</div>\r\n';
		}
		else if(downloadbar.Status.fail==obj.status){
			ret+='<div id="onrestart" class="download-item-restart" onclick="downloadbar.sendMsgToDownload('+"'restart'"+','+obj.id+');">重新下载</div>\r\n';
			ret+='<div id="ondelete" class="download-item-restart" onclick="downloadbar.sendMsgToDownload('+"'deltask'"+','+obj.id+');">删除任务</div>\r\n';			
		}
		else if(downloadbar.Status.pause==obj.status){
			ret+='<span class="download-item-status">已暂停</span>';		
			ret+='<div id="onstart"  class="download-item-start" onclick="downloadbar.sendMsgToDownload('+"'start'"+','+obj.id+');">继续下载</div>\r\n';
		}
		
		return ret;
	},
	// 根据数据拼出  download-item-info
	getInnerInfo:function (obj){
		ret='<div class="download-item-info"> \r\n';
		
		ret+='<div class="download-item-size"> \r\n';
		ret+='</div> \r\n';
		if (downloadbar.Status.initnew == obj.status){
			if ("" == obj.totalsize){
				ret+='<span class="downloaded-size">'+"0B"+'</span>/<span class="download-total-size">'+"0B"+'</span> \r\n';
			}else {
				ret+='<span class="downloaded-size">'+obj.currentsize+'</span>/<span class="download-total-size">'+obj.totalsize+'</span> \r\n';
			}		
			ret+='<span class="download-item-status">'+""+'</span>';
		}else if (downloadbar.Status.download == obj.status){
			if ("" == obj.totalsize){
				ret+='<span class="downloaded-size">'+"0B"+'</span>/<span class="download-total-size">'+"0B"+'</span> \r\n';
			}else {
				ret+='<span class="downloaded-size">'+obj.currentsize+'</span>/<span class="download-total-size">'+obj.totalsize+'</span> \r\n';
			}		
			ret+='<span class="download-item-status">'+obj.timeremain+'</span>';
		}
		
		ret+='</div> \r\n';
		return ret;
	},
	// 根据数据拼出来 process div
	getProcess:function (obj){
		var per = obj.ratio*100;
		console.info(per);
		var percent = String(per)+"%";
		console.info("percent: "+percent);
		var ret='<div class="download-process" style="width: '+ percent +'"></div>';
		return ret;
	},
	refreshItem:function (para){
		var ind = downloadbar.getItemIndex(para);
		if (-1==ind){
			//alert("refreshItem can't find index");
			return ;
		}
		
		downloadbar.tasklist[ind].timeused = unescape(para.timeused);
		downloadbar.tasklist[ind].name = unescape(para.name);	
		downloadbar.tasklist[ind].timeremain = unescape(para.timeremain);
		downloadbar.tasklist[ind].avgspeed = unescape(para.avgspeed);
		downloadbar.tasklist[ind].totalsize = unescape(para.totalsize);
		downloadbar.tasklist[ind].currentsize = unescape(para.currentsize);
		downloadbar.tasklist[ind].ratio = unescape(para.ratio);
		downloadbar.tasklist[ind].filetype = unescape(para.filetype);		
		var needsort=(downloadbar.tasklist[ind].status != para.status); 
		downloadbar.tasklist[ind].status = unescape(para.status);
		downloadbar.tasklist[ind].openbtntext = unescape(para.openbtntext);
		var objHTML = downloadbar.getHTML(downloadbar.tasklist[ind]);
		var aim=$("#download-items .download-item[taskid="+downloadbar.tasklist[ind].id+"]");
		aim[0].outerHTML=objHTML;
		// 添加响应Listener
		// 需要重新取一次
		downloadbar.bindButtonClick( objHTML, downloadbar.tasklist[ind].id);
		return needsort;
	},
	onItemClick:function (){
		//alert("click me");
	},
	getItemIndex:function (para){
		for (var i=0; i<downloadbar.tasklist.length; i++){
			if (downloadbar.tasklist[i].id == para.id){
				return i;
			}
		}
		return -1;
	},
	
	TaskInfo:function (id, url, name, savepath, filetype){
		// public
		this.id=id;
		this.url=url;
		this.name=name;
		this.status="new";
		this.savepath=savepath;
		this.timeused="";
		this.timeremain="";
		this.avgspeed="";
		this.totalsize="";
		this.currentsize="";
		this.filetype=filetype;
		this.ratio=0;
		// private
		this.actstamp=(new Date()).getTime();
	},
	test_init:function (taskid){
		var para ={
			id:taskid,
			msgtype:"new",
			url:"http://a.com/a.iso",
			name: '测试.iso',
			savepath: 'c:\abc.iso'
		};
		downloadbar.updateItem(para);
		//var aim=$(".download-item[taskid='2']");
		//console.info(aim);
		var val =0;
		setTimeout(dotask,1000);
		function dotask(){
			val+=50;
			var ratio = val/300.0;
			console.info(ratio);
			var para = {
				id:taskid,
				msgtype:"update",
				status:"download",
				currentsize: val+"MB",
				totalsize:"300MB",
				ratio: ratio,
				filetype :"common",
				timeremain: "还有"+(300-val)/100+"sdgsdfgsdfgsdgsdfgsdfgsdfgfsd秒",
			};
			console.info(para);
			if (val<=100){
				downloadbar.updateItem(para);
				setTimeout(dotask,1000);
			}else{
				// complete
				if(2 == para.id)
				{
					para.status="complete";
					para.ratio=1;
					downloadbar.updateItem(para);
				}
				else
				{
				//	para.status="complete";
				//	para.ratio=1;
				//	downloadbar.updateItem(para);					
				}
			//	setTimeout(remove_test,5000);
			}
			downloadbar.updataStatusbarIcon(para);
		}
		function remove_test(){
//			alert(taskid + "will delete");
			downloadbar.updateItem({id:taskid, msgtype:"delete" });
		}
	},
};

$().ready(downloadbar.init);	
	


	

